/*==============================================================================
*This .do file brings in the UK 1981 Small Area Statistics 
* Data downloaded from NOMIS official labour market statistics 
* http://www.nomisweb.co.uk/
*=============================================================================*/
set more off
clear

cd "$insheet_files/UK"

clear
import excel using "crosswalk_wards.xls", sheet("1981") cellrange(A1:B10429) firstrow 

rename label ZoneID
rename nuts_id nuts 

sort ZoneID
save nuts_local_crosswalk_1981.dta, replace

import excel using "UK_Census_1981_wards.xls", first cellrange(A2:IV10905) clear

merge 1:1 ZoneID using nuts_local_crosswalk_1981.dta

*some non-matches, fill in by hand
replace nuts = "UKI11" if zone_name == "VINTRY"

gen ZoneID_2 = substr(ZoneID,1,4)
replace nuts = "UKI11" if ZoneID_2 =="01AA" & nuts==""
replace nuts = "UKE22" if ZoneID_2 =="37PB" & nuts==""
replace nuts = "UKK22" if ZoneID_2 =="20GJ" & nuts==""
replace nuts = "UKK41" if ZoneID_2 =="19GA"& nuts=="" 
replace nuts = "UKJ31" if ZoneID_2 =="25JM"& nuts=="" 
replace nuts = "UKJ33" if ZoneID_2 =="25JL"& nuts=="" 
replace nuts = "UKM63" if ZoneID_2 =="6332" & nuts=="" 

replace nuts = "UKK12" if zone_name == "YATE WEST" & nuts==""
replace nuts = "UKH12" if zone_name =="HEMINGFORD GREY" & nuts==""
replace nuts = "UKK30" if zone_name =="ST.AGNES" & nuts==""
replace nuts = "UKK30" if zone_name =="ST.MARTINS" & nuts==""
replace nuts = "UKK30" if zone_name =="ST.MARY'S" & nuts==""
replace nuts = "UKK30" if zone_name =="TRESCO" & nuts==""
replace nuts = "UKK43" if zone_name =="CULLOMPTON TOWN" & nuts==""
replace nuts = "UKJ33" if zone_name =="HAYLING WEST" & nuts==""
replace nuts = "UKE13" if zone_name =="RIDDINGS EAST" & nuts==""
replace nuts = "UKJ41" if zone_name =="RIVERSIDE" & nuts==""
replace nuts = "UKJ42" if zone_name =="IWADE & LOWER HALSTOW" & nuts==""
replace nuts = "UKD43" if zone_name =="SCOTFORTH EAST" & nuts==""
replace nuts = "UKC21" if zone_name =="HEDDON-ON-THE-WALL" & nuts==""
replace nuts = "UKG24" if zone_name =="ST.MICHAEL'S" & nuts=="" 
replace nuts = "UKH33" if zone_name =="TYE GREEN" & nuts==""

drop if nuts=="" //small number of people in areas labelled "SHIPPING" ?

* Generate Nuts 1 & 2 codes from the NUTS 3 codes  

local sum_var sas*

collapse (sum) `sum_var', by(nuts) 

gen nuts_level=3 

tempfile nuts3
save `nuts3.dta'

gen nuts2=substr(nuts,1,4)
	
collapse (sum) `sum_var', by(nuts2) 
	
rename nuts2 nuts
gen nuts_level=2
	
tempfile nuts2
save `nuts2.dta'
	
clear
use `nuts3.dta'
	
gen nuts1=substr(nuts,1,3)

collapse (sum) `sum_var', by(nuts1) 
	
rename nuts1 nuts
gen nuts_level=1

tempfile nuts1
save `nuts1.dta'
	
gen country=substr(nuts,1,2)

collapse (sum) `sum_var', by(country) 
	
rename country nuts
gen nuts_level=0
	
append using `nuts1.dta'	
append using `nuts2.dta'
append using `nuts3.dta'

********************************************************************************

rename sas010036 POP  
rename sas050394 EMP
rename sas050401 UNEMP  

note: industry is a 10% sample
rename sas464450 ind_total_male_16_plus
rename sas464490 ind_total_female_16_plus

rename sas464451 ind_agro_male_16_plus
rename sas464491 ind_agro_female_16_plus
rename sas464452 ind_energy_male_16_plus
rename sas464492 ind_energy_female_16_plus
rename sas464453 ind_mnfg_male_16_plus
rename sas464493 ind_mnfg_female_16_plus
rename sas464454 ind_construction_male_16_plus
rename sas464494 ind_construction_female_16_plus
rename sas464455 serv_distribution_male_16_plus
rename sas464495 serv_distribution_female_16_plus
rename sas464456 serv_transport_male_16_plus
rename sas464496 serv_transport_female_16_plus
rename sas464457 serv_other_male_16_plus
rename sas464497 serv_other_female_16_plus

rename sas515333 serv_finance_male
rename sas515361 serv_finance_female
rename sas515334 serv_admin_other_male
rename sas515362 serv_admin_other_female

********************************************************************************
egen ind_agro =rsum(ind_agro*)

egen ind_mnfg = rsum(ind_mnfg*)
egen ind_energy = rsum(ind_energy*)
egen ind_construction = rsum(ind_construction*)
egen ind_total = rsum(ind_mnfg - ind_construction)

egen serv_commerce = rsum(serv_distribution*)
egen serv_transport = rsum(serv_transport*)
egen serv_credit = rsum(serv_finance*)
* Note: serv_admin includes "other services" in this case
egen serv_admin = rsum(serv_admin*) 

egen serv_total =rsum(serv_commerce-serv_admin)

********************************************************************************
gen year = 1981

keep nuts year POP EMP UNEMP

*Report data in thousands
foreach var of varlist POP EMP UNEMP {
	replace `var'=`var'/1000
}

rename POP POP_uk_census_1981 
rename EMP EMP_uk_census_1981
rename UNEMP UNEMP_uk_census_1981
gen LF_uk_census_1981 = EMP_uk_census_1981 + UNEMP_uk_census_1981

save "$dta_files/UK_CENS1981_labor.dta", replace

rm nuts_local_crosswalk_1981.dta
